/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkElement;
import filenet.vw.api.VWXMLData;
import filenet.vw.server.VWField;
import filenet.vw.server.VWFieldUtility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class VWFieldsObject
implements Serializable {
    private static final long serialVersionUID = 119062L;
    private VWField[] fields;
    private transient HashMap<String, VWField> fieldMap = null;
    protected static final String HiddenFields = "*";
    protected static final String VWWorkObjectName = "*F_WorkObjectName";
    protected static final String VWTag = "*F_Tag";
    protected static final String VWWobNum = "*F_WorkObjectNumber";
    protected static final String VWWorkClassName = "*F_WorkClass";
    protected static final String VWWorkPerformerClassName = "*F_WPClassName";
    protected static final String VWOperationName = "*F_Operation";
    protected static final String VWInstructionSheetName = "*F_ISheetName";
    protected static final String VWLockedUserName = "*F_LockedUserName";
    protected static final String VWWorkOrderId = "*F_WorkOrderId";
    protected static final String VWCurrentQueue = "*F_CurrentQueue";
    protected static final String VWWorkSpaceId = "*F_WorkSpaceId";
    protected static final String VWWorkClassId = "*F_WorkClassId";
    protected static final String VWBoundUserName = "*F_BoundUserName";
    protected static final String FWobNum = "F_WobNum";
    protected static final String FTag = "F_Tag";
    protected static final String FLocked = "F_Locked";
    protected static final String FServerId = "F_ServerId";
    protected static final String FLockedMachineId = "F_LockMachine";
    protected static final String FWorkOrderId = "F_WorkOrderId";
    protected static final String FStepName = "F_StepName";
    protected static final String FStartTime = "F_StartTime";
    protected static final String FEnqueueTime = "F_EnqueueTime";
    protected static final String FTrackers = "F_Trackers";
    protected static final String FOperation = "F_Operation";
    protected static final String FOperationId = "F_OperationId";
    protected static final String FWorkflowNumber = "F_WorkFlowNumber";
    protected static final String FOverdue = "F_Overdue";
    protected static final String FIsTracker = "F_TrackerStatus";
    protected static final String FResponses = "F_Responses";
    protected static final String FWorkSpaceId = "F_WorkSpaceId";
    protected static final String FWorkClassId = "F_WorkClassId";
    protected static final String FLastErrorNumber = "F_LastErrorNumber";
    protected static final String FLastErrorText = "F_LastErrorText";
    protected static final String FWSStatus = "F_WsStatus";
    protected static final String FStepDescription = "F_StepDescription";
    protected static final String FClass = "F_Class";
    protected static final String FComment = "F_Comment";
    protected static final String FInstructionSheetName = "F_InstrSheetName";
    protected static final String FResponse = "F_Response";
    protected static final String FSubject = "F_Subject";
    protected static final String FWorkflowName = "F_WorkflowName";
    protected static final String IWRosterName = "*F_RosterName";
    protected static final String IWDateReceived = "*F_StepReceived";
    protected static final String IWOriginator = "*F_Originator";
    protected static final String IWTrackers = "*F_Trackers";
    protected static final String IWLaunchDate = "*F_StartTime";
    protected static final String IWParticipantName = "*F_ParticipantName";
    protected static final String IWDeadline = "*F_Deadline";
    protected static final String IWReminder = "*F_Reminder";
    protected static final String IWOverdue = "*F_Overdue";
    protected static final String IWIsTracker = "*F_TrackerStatus";
    protected static final String IWWorkflowNumber = "*F_WorkFlowNumber";
    protected static final String IWOperationId = "*F_OperationId";
    protected static final String IWOperationType = "*F_OperationType";
    protected static final String IWUIFlag = "*F_UIFlag";
    protected static final String IWStepName = "*F_StepName";
    protected static final String IWStepProcId = "*F_StepProcId";
    protected static final String IWSourceDoc = "*F_SourceDoc";
    protected static final String IWStepDescription = "*F_StepDescription";
    protected static final String IWStepResponses = "*F_StepResponses";
    protected static final Long NO_DATE = new Long("-2000000000000");
    protected static final int NO_INTEGER = 0;
    protected static final boolean NO_BOOLEAN = false;
    protected static final int BASEOPERATION = 10000;
    private transient String[] nonHiddenFields = null;
    private transient VWField[] nonSystemFields = null;

    VWFieldsObject() {
    }

    protected String[] getFieldNames(boolean getSystemFields) {
        int nFields;
        int n = nFields = this.fields == null ? 0 : this.fields.length;
        if (nFields > 0) {
            int i;
            String[] names = this.getFieldNames();
            int nNames = names == null ? 0 : names.length;
            String[] results = new String[nNames];
            int j = 0;
            try {
                for (i = 0; i < nNames; ++i) {
                    if (this.isSystemField(names[i]) != getSystemFields || names[i] == null) continue;
                    results[j] = names[i];
                    ++j;
                }
            }
            catch (VWException e) {
                // empty catch block
            }
            if (nNames == j) {
                return names;
            }
            String[] f = new String[j];
            for (i = 0; i < nFields; ++i) {
                if (names[i] == null) continue;
                f[i] = names[i];
            }
            return f;
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getFieldNames() {
        if (this.nonHiddenFields == null) {
            int nFields;
            int n = nFields = this.fields == null ? 0 : this.fields.length;
            if (nFields == 0) {
                this.nonHiddenFields = new String[0];
            } else {
                VWFieldsObject vWFieldsObject = this;
                synchronized (vWFieldsObject) {
                    String[] names = new String[nFields];
                    int j = 0;
                    String tmpstr = null;
                    for (VWField f : this.fields) {
                        if (f == null || (tmpstr = f.getName()).startsWith(HiddenFields)) continue;
                        names[j] = tmpstr;
                        ++j;
                    }
                    if (nFields == j) {
                        this.nonHiddenFields = names;
                    } else {
                        this.nonHiddenFields = new String[j];
                        System.arraycopy(names, 0, this.nonHiddenFields, 0, j);
                    }
                }
            }
        }
        return this.nonHiddenFields;
    }

    protected String[] getFilteredFieldNames(boolean getSystemDefinedFields) {
        String[] names = this.getFieldNames();
        int nNames = names == null ? 0 : names.length;
        String[] results = new String[nNames];
        int j = 0;
        for (String s : names) {
            if (s.startsWith("F_") != getSystemDefinedFields) continue;
            results[j] = s;
            ++j;
        }
        if (nNames == j) {
            return names;
        }
        String[] f = new String[j];
        System.arraycopy(results, 0, f, 0, j);
        return f;
    }

    protected VWField getField(String fieldName) {
        return this.getFieldMap().get(fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, VWField> getFieldMap() {
        if (this.fieldMap == null) {
            VWFieldsObject vWFieldsObject = this;
            synchronized (vWFieldsObject) {
                int nFields;
                int n = nFields = this.fields == null ? 0 : this.fields.length;
                if (this.fieldMap == null) {
                    this.fieldMap = new HashMap(nFields);
                    for (VWField f : this.fields) {
                        if (f == null) continue;
                        this.fieldMap.put(f.getName(), f);
                    }
                }
            }
        }
        return this.fieldMap;
    }

    protected synchronized VWField[] getFields() {
        return this.fields;
    }

    protected synchronized void setFields(VWField[] newFields) {
        this.cleanUp();
        this.fields = newFields;
    }

    protected boolean hasFieldName(String fieldName) throws VWException {
        if (fieldName == null) {
            throw new VWException("vw.api.FOHasFieldNameNull", "Field name parameter null.");
        }
        return this.getFieldMap().containsKey(fieldName);
    }

    protected Object getFieldValue(String fieldName) throws VWException {
        return this.getFieldValue(fieldName, false);
    }

    protected Object getFieldValue(String fieldName, boolean dontThrow) throws VWException {
        Object value = null;
        try {
            if (fieldName == null) {
                if (dontThrow) {
                    return value;
                }
                throw new VWException("vw.api.FOGetFieldValueFieldNameNull", "getFieldValue:Error field parameter is null.");
            }
            VWField field = this.getField(fieldName);
            if (field == null) {
                if (dontThrow) {
                    return value;
                }
                throw new VWException("vw.api.FOGetFieldValueFieldNotFound", "getFieldValue:Error field not found. {0}", fieldName);
            }
            value = field.getValue();
            switch (field.getType()) {
                case 32: {
                    if (field.isArray()) {
                        Object[] strs = null;
                        int len = 0;
                        if (value instanceof Object[]) {
                            len = ((Object[])value).length;
                            strs = (Object[])value;
                        }
                        VWAttachment[] theArray = new VWAttachment[len];
                        for (int i = 0; i < len; ++i) {
                            if (strs[i] != null && strs[i] instanceof VWAttachment) {
                                theArray[i] = (VWAttachment)strs[i];
                                continue;
                            }
                            if (strs[i] == null || !(strs[i] instanceof String)) continue;
                            theArray[i] = new VWAttachment((String)strs[i]);
                        }
                        return theArray;
                    }
                    VWAttachment newAttachment = null;
                    if (value != null && value instanceof VWAttachment) {
                        newAttachment = (VWAttachment)value;
                    } else if (value != null && value instanceof String) {
                        newAttachment = new VWAttachment((String)value);
                    }
                    return newAttachment;
                }
                case 64: {
                    if (field.isArray()) {
                        int nObjs;
                        VWParticipant[] theArray = null;
                        Object[] arrayOfObject = null;
                        if (value instanceof Object[]) {
                            arrayOfObject = (Object[])value;
                        }
                        int n = nObjs = arrayOfObject == null ? 0 : arrayOfObject.length;
                        if (nObjs == 0) {
                            theArray = new VWParticipant[]{new VWParticipant("")};
                            return theArray;
                        }
                        theArray = new VWParticipant[nObjs];
                        for (int i = 0; i < nObjs; ++i) {
                            if (arrayOfObject[i] != null) {
                                if (arrayOfObject[i] instanceof VWParticipant) {
                                    theArray[i] = (VWParticipant)arrayOfObject[i];
                                    continue;
                                }
                                theArray[i] = new VWParticipant(arrayOfObject[i].toString());
                                continue;
                            }
                            theArray[i] = new VWParticipant("");
                        }
                        return theArray;
                    }
                    if (value instanceof VWParticipant) {
                        return value;
                    }
                    VWParticipant newParticipant = null;
                    if (value != null && value instanceof String) {
                        newParticipant = new VWParticipant((String)value);
                    }
                    return newParticipant;
                }
                case 128: {
                    if (field.isArray()) {
                        Object[] strs = null;
                        int len = 0;
                        if (value instanceof Object[]) {
                            len = ((Object[])value).length;
                            strs = (Object[])value;
                        }
                        VWXMLData[] theArray = new VWXMLData[len];
                        for (int i = 0; i < len; ++i) {
                            if (strs[i] != null && strs[i] instanceof VWXMLData) {
                                theArray[i] = (VWXMLData)strs[i];
                                continue;
                            }
                            if (strs[i] == null || !(strs[i] instanceof String)) continue;
                            theArray[i] = new VWXMLData((String)strs[i], null, null, true);
                        }
                        return theArray;
                    }
                    VWXMLData newXML = null;
                    if (value != null && value instanceof VWXMLData) {
                        newXML = (VWXMLData)value;
                    } else if (value != null && value instanceof String) {
                        newXML = new VWXMLData((String)value, null, null, true);
                    }
                    return newXML;
                }
                case 512: {
                    if (field.isArray()) {
                        Object[] strs = null;
                        int len = 0;
                        if (value instanceof Object[]) {
                            strs = (Object[])value;
                            len = strs.length;
                        }
                        VWGuid[] theArray = new VWGuid[len];
                        for (int i = 0; i < len; ++i) {
                            if (strs[i] == null) continue;
                            if (strs[i] instanceof VWGuid) {
                                theArray[i] = (VWGuid)strs[i];
                                continue;
                            }
                            if (!(strs[i] instanceof String)) continue;
                            theArray[i] = new VWGuid((String)strs[i]);
                        }
                        return theArray;
                    }
                    VWGuid newGuid = null;
                    if (value != null) {
                        if (value instanceof VWGuid) {
                            newGuid = (VWGuid)value;
                        } else if (value instanceof String) {
                            newGuid = new VWGuid((String)value);
                        }
                    }
                    return newGuid;
                }
            }
        }
        catch (VWException e) {
            if (dontThrow) {
                return value;
            }
            throw e;
        }
        return value;
    }

    protected void setFieldValue(String fieldName, Object fieldValue, boolean compareValue) throws VWException {
        if (fieldName == null) {
            throw new VWException("vw.api.FOSetFieldValueFieldNameNull", "Field name parameter is null.");
        }
        if (!this.hasFieldName(fieldName)) {
            throw new VWException("vw.api.FOSetFieldValueFieldNameNotFound", "Field name parameter is not found. {0}", fieldName);
        }
        if (this.isSystemField(fieldName)) {
            throw new VWException("vw.api.FOSetFieldValueSystemField", "System Fields cannot be set. {0}", fieldName);
        }
        VWField f = this.getField(fieldName);
        if (f != null) {
            fieldValue = VWFieldUtility.convertFieldValue(fieldValue, f.getType(), fieldName, f.isArray());
            f.setValue(fieldValue, compareValue);
        }
    }

    protected boolean hasBeenAltered(String fieldName) throws VWException {
        if (fieldName == null) {
            throw new VWException("vw.api.FOHasBeenAlteredNameNull", "Field name parameter null.");
        }
        VWField field = this.getField(fieldName);
        if (field == null) {
            throw new VWException("vw.api.FOhasBAlteredFieldNotFound", "hasBeenAltered:field name not found.");
        }
        return field.hasBeenAltered();
    }

    protected boolean isSystemField(String fieldName) throws VWException {
        if (fieldName == null) {
            throw new VWException("vw.api.FOIsSystemFieldNameNull", "Field name parameter null.");
        }
        VWField field = this.getField(fieldName);
        if (field == null) {
            throw new VWException("vw.api.FOisSystemFieldNotFound", "isSystemField:field name not found. {0}", fieldName);
        }
        return field.isSystemField();
    }

    protected boolean getIsAltered() {
        if (this.fields != null) {
            for (VWField f : this.fields) {
                if (f == null || !f.hasBeenAltered()) continue;
                return true;
            }
        }
        return false;
    }

    protected int getFieldMode(String fieldName) throws VWException {
        if (fieldName == null) {
            throw new VWException("vw.api.FOgetFieldMode", "Field name parameter null.");
        }
        VWField field = this.getField(fieldName);
        if (field == null) {
            throw new VWException("vw.api.FOGetFieldModeFieldNotFound", "Field name parameter is not found. {0}", fieldName);
        }
        return field.getMode();
    }

    protected VWField[] getUpdateFields() {
        VWField[] theFields = this.getNonSystemFields();
        int nFields = theFields == null ? 0 : theFields.length;
        ArrayList<VWField> alteredFields = new ArrayList<VWField>(nFields);
        if (nFields > 0) {
            for (VWField f : theFields) {
                if (f == null || !f.hasBeenAltered()) continue;
                alteredFields.add(f);
            }
        }
        alteredFields.trimToSize();
        return alteredFields.toArray(new VWField[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VWField[] getNonSystemFields() {
        if (this.nonSystemFields == null) {
            int nFields;
            int n = nFields = this.fields == null ? 0 : this.fields.length;
            if (nFields == 0) {
                this.nonSystemFields = new VWField[0];
            } else {
                VWFieldsObject vWFieldsObject = this;
                synchronized (vWFieldsObject) {
                    ArrayList<VWField> nonsysFields = new ArrayList<VWField>(nFields);
                    for (VWField f : this.fields) {
                        if (f == null || f.isSystemField()) continue;
                        nonsysFields.add(f);
                    }
                    this.nonSystemFields = nonsysFields.toArray(new VWField[0]);
                }
            }
        }
        return this.nonSystemFields;
    }

    protected void resetAlteredFieldsFlag() {
        if (this.fields == null) {
            return;
        }
        for (VWField f : this.fields) {
            if (f == null || f.isSystemField()) continue;
            f.resetAlteredFlag();
        }
    }

    protected String getWorkObjectNumber() throws VWException {
        String value = null;
        Object tmpval = null;
        tmpval = this.hasFieldName(VWWobNum) ? this.getFieldValue(VWWobNum) : this.getFieldValue(FWobNum, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getWorkObjectName() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(VWWorkObjectName, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getTag() throws VWException {
        String value = null;
        Object tmpval = null;
        tmpval = this.hasFieldName(VWTag) ? this.getFieldValue(VWTag) : this.getFieldValue(FTag, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getWorkClassName() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(VWWorkClassName, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getWorkPerformerClassName() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(VWWorkPerformerClassName, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getCurrentQueueName() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(VWCurrentQueue, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getOperationName() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(VWOperationName, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getInstructionSheetName() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(VWInstructionSheetName, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getLastErrorNumber() throws VWException {
        Object status;
        String value = null;
        Object tmpval = this.getFieldValue(FLastErrorNumber, true);
        if ((null == tmpval || tmpval instanceof Integer && (Integer)tmpval == 0) && null != (status = this.getFieldValue(FWSStatus, true)) && status instanceof Integer && (Integer)status > 1) {
            tmpval = status;
        }
        if (tmpval != null && tmpval instanceof Integer) {
            value = Integer.toHexString((Integer)tmpval);
        }
        return value;
    }

    protected String getLastErrorText() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(FLastErrorText, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected VWParameter[] getParameters() throws VWException, ArrayStoreException, ArrayIndexOutOfBoundsException {
        int nFields;
        int n = nFields = this.fields == null ? 0 : this.fields.length;
        if (nFields > 0) {
            VWParameter[] parameters = new VWParameter[nFields];
            int j = 0;
            String tmpstr = null;
            boolean isSystemField = false;
            for (VWField f : this.fields) {
                if (f == null) continue;
                isSystemField = false;
                tmpstr = f.getName();
                if (tmpstr.startsWith(HiddenFields)) continue;
                if (tmpstr.startsWith("F_")) {
                    isSystemField = true;
                }
                parameters[j] = new VWParameter(tmpstr, f.getMode(), f.getType(), f.isArray(), isSystemField, f.getDescription(), (VWWorkElement)this);
                parameters[j].internalSetValue(f.getValue());
                ++j;
            }
            if (nFields == j) {
                return parameters;
            }
            VWParameter[] results = new VWParameter[j];
            System.arraycopy(parameters, 0, results, 0, j);
            return results;
        }
        return new VWParameter[0];
    }

    protected VWParameter getParameter(String name) throws VWException {
        VWParameter tmpParameter = null;
        if (this.fields == null) {
            return null;
        }
        VWField f = this.getField(name);
        if (f != null) {
            boolean isSystemField = false;
            if (name.startsWith("F_")) {
                isSystemField = true;
            }
            tmpParameter = new VWParameter(name, f.getMode(), f.getType(), f.isArray(), isSystemField, f.getDescription(), (VWWorkElement)this);
            tmpParameter.internalSetValue(f.getValue());
        }
        return tmpParameter;
    }

    protected VWParameter[] getFilteredParameters(boolean getSystemDefinedFields) throws VWException, ArrayStoreException, ArrayIndexOutOfBoundsException {
        int nFields;
        int n = nFields = this.fields == null ? 0 : this.fields.length;
        if (nFields > 0) {
            VWParameter[] parameters = new VWParameter[nFields];
            int j = 0;
            String tmpstr = null;
            boolean isSystemField = false;
            for (VWField f : this.fields) {
                if (f == null) continue;
                isSystemField = false;
                tmpstr = f.getName();
                if (tmpstr.startsWith(HiddenFields) || tmpstr.startsWith("F_") != getSystemDefinedFields) continue;
                isSystemField = true;
                parameters[j] = new VWParameter(tmpstr, f.getMode(), f.getType(), f.isArray(), isSystemField, f.getDescription(), (VWWorkElement)this);
                parameters[j].internalSetValue(f.getValue());
                ++j;
            }
            if (this.fields.length == j) {
                return parameters;
            }
            VWParameter[] results = new VWParameter[j];
            System.arraycopy(parameters, 0, results, 0, j);
            return results;
        }
        return new VWParameter[0];
    }

    protected VWDataField[] getDataFields() throws VWException, ArrayStoreException, ArrayIndexOutOfBoundsException {
        int nFields;
        int n = nFields = this.fields == null ? 0 : this.fields.length;
        if (nFields > 0) {
            VWDataField[] dataFields = new VWDataField[nFields];
            int j = 0;
            String tmpstr = null;
            for (VWField f : this.fields) {
                if (f == null) continue;
                boolean isSystemField = false;
                tmpstr = f.getName();
                if (tmpstr == null || tmpstr.startsWith(HiddenFields)) continue;
                if (tmpstr.startsWith("F_")) {
                    isSystemField = true;
                }
                dataFields[j] = new VWDataField(tmpstr, f.getType(), isSystemField, f.isArray(), f.getMode(), (VWWorkElement)this);
                dataFields[j].internalSetValue(f.getValue());
                ++j;
            }
            if (this.fields.length == j) {
                return dataFields;
            }
            VWDataField[] results = new VWDataField[j];
            System.arraycopy(dataFields, 0, results, 0, j);
            return results;
        }
        return new VWDataField[0];
    }

    protected VWDataField getDataField(String name) throws VWException {
        if (this.fields == null) {
            return null;
        }
        VWDataField tmpDataField = null;
        for (VWField f : this.fields) {
            if (f == null || !f.getName().equals(name)) continue;
            String tmpstr = f.getName();
            if (tmpstr == null || tmpstr.startsWith(HiddenFields)) break;
            boolean isSystemField = false;
            if (tmpstr.startsWith("F_")) {
                isSystemField = true;
            }
            tmpDataField = new VWDataField(tmpstr, f.getType(), isSystemField, f.isArray(), f.getMode(), (VWWorkElement)this);
            tmpDataField.internalSetValue(f.getValue());
            break;
        }
        return tmpDataField;
    }

    protected VWDataField[] getFilteredDataFields(boolean getSystemDefinedFields) throws VWException, ArrayStoreException, ArrayIndexOutOfBoundsException {
        int nFields;
        int n = nFields = this.fields == null ? 0 : this.fields.length;
        if (nFields > 0) {
            VWDataField[] dataFields = new VWDataField[nFields];
            int j = 0;
            String tmpstr = null;
            for (VWField f : this.fields) {
                if (f == null) continue;
                boolean isSystemField = false;
                tmpstr = f.getName();
                if (tmpstr.startsWith("F_")) {
                    isSystemField = true;
                }
                if (tmpstr.startsWith(HiddenFields) || tmpstr.startsWith("F_") != getSystemDefinedFields) continue;
                dataFields[j] = new VWDataField(tmpstr, f.getType(), isSystemField, f.isArray(), f.getMode(), (VWWorkElement)this);
                dataFields[j].internalSetValue(f.getValue());
                ++j;
            }
            if (nFields == j) {
                return dataFields;
            }
            VWDataField[] results = new VWDataField[j];
            System.arraycopy(dataFields, 0, results, 0, j);
            return results;
        }
        return new VWDataField[0];
    }

    protected String getComment() throws VWException {
        String value = null;
        Object tmpval = null;
        tmpval = this.getFieldValue(FComment, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected Date getDateReceived() throws VWException {
        Object value = null;
        Date result = null;
        try {
            value = this.hasFieldName(IWDateReceived) ? this.getFieldValue(IWDateReceived) : this.getFieldValue(FEnqueueTime, true);
            if (value != null && NO_DATE.longValue() != ((Date)value).getTime()) {
                result = (Date)value;
            }
        }
        catch (Exception e) {
            throw new VWException("vw.api.FOBadEnqueueDate", "Enqueue Date format error. {0} ", e.getMessage());
        }
        return result;
    }

    protected String getOriginator() throws VWException {
        String result = null;
        Object value = this.getFieldValue(IWOriginator, true);
        if (value != null && value instanceof VWParticipant) {
            result = ((VWParticipant)value).getParticipantName();
        }
        return result;
    }

    protected VWParticipant getOriginatorPx() throws VWException {
        VWParticipant aParticipant = null;
        Object value = this.getFieldValue(IWOriginator, true);
        if (value != null && value instanceof VWParticipant) {
            aParticipant = (VWParticipant)value;
        }
        return aParticipant;
    }

    protected String[] getTrackers() throws VWException {
        int nPxList;
        VWParticipant[] pxList = null;
        String[] trackers = null;
        pxList = this.getTrackersPx();
        int n = nPxList = pxList == null ? 0 : pxList.length;
        if (nPxList > 0) {
            trackers = new String[nPxList];
            for (int i = 0; i < nPxList; ++i) {
                trackers[i] = pxList[i].getParticipantName();
            }
        }
        return trackers;
    }

    protected VWParticipant[] getTrackersPx() throws VWException {
        Object[] value = null;
        VWParticipant[] trackers = null;
        value = this.hasFieldName(IWTrackers) ? (Object[])this.getFieldValue(IWTrackers) : (Object[])this.getFieldValue(FTrackers, true);
        if (value != null && value instanceof VWParticipant[]) {
            trackers = (VWParticipant[])value;
        }
        return trackers;
    }

    protected Date getLaunchDate() throws VWException {
        Object value = null;
        Date result = null;
        try {
            value = this.hasFieldName(IWLaunchDate) ? this.getFieldValue(IWLaunchDate) : this.getFieldValue(FStartTime, true);
            if (value != null && NO_DATE.longValue() != ((Date)value).getTime()) {
                result = (Date)value;
            }
        }
        catch (Exception e) {
            throw new VWException("vw.api.FOBadStartDateFormat", "Start Date format error. {0} ", e.getMessage());
        }
        return result;
    }

    protected String getLockedUser() throws VWException {
        String result = null;
        Object value = this.getFieldValue(VWLockedUserName, true);
        if (value != null) {
            if (value instanceof VWParticipant) {
                result = ((VWParticipant)value).getParticipantName();
            } else if (value instanceof String) {
                result = (String)value;
            }
        }
        return result;
    }

    protected VWParticipant getLockedUserPx() throws VWException {
        VWParticipant result = null;
        Object value = this.getFieldValue(VWLockedUserName, true);
        if (value != null && value instanceof VWParticipant) {
            result = (VWParticipant)value;
        }
        return result;
    }

    protected VWParticipant getBoundUserPx() throws VWException {
        VWParticipant result = null;
        Object value = this.getFieldValue(VWBoundUserName, true);
        if (value != null && value instanceof VWParticipant) {
            result = (VWParticipant)value;
        }
        return result;
    }

    protected String getParticipantName() throws VWException {
        String result = null;
        Object value = this.getFieldValue(IWParticipantName, true);
        if (value != null && value instanceof VWParticipant) {
            result = ((VWParticipant)value).getParticipantName();
        }
        return result;
    }

    protected VWParticipant getParticipantNamePx() throws VWException {
        VWParticipant result = null;
        Object value = this.getFieldValue(IWParticipantName, true);
        if (value != null && value instanceof VWParticipant) {
            result = (VWParticipant)value;
        }
        return result;
    }

    protected Date getDeadline() throws VWException {
        Object value = null;
        value = this.getFieldValue(IWDeadline, true);
        Date result = null;
        if (value != null && NO_DATE.longValue() != ((Date)value).getTime()) {
            result = (Date)value;
        }
        return result;
    }

    protected int getUIFlag() throws VWException {
        Object value = null;
        value = this.getFieldValue(IWUIFlag, true);
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    protected int getOverdue() throws VWException {
        Object value = null;
        int result = 0;
        value = this.hasFieldName(IWOverdue) ? this.getFieldValue(IWOverdue) : this.getFieldValue(FOverdue, true);
        if (value != null) {
            result = (Integer)value;
        }
        return result;
    }

    protected int getOperationType() throws VWException {
        Object value = null;
        int result = 0;
        value = this.hasFieldName(IWOperationId) ? this.getFieldValue(IWOperationId) : this.getFieldValue(FOperationId, true);
        if (value != null && (result = ((Integer)value).intValue()) > 9999) {
            result = 33;
        }
        return result;
    }

    protected int getProcessorId() throws VWException {
        Object value = null;
        if (this.hasFieldName(IWStepProcId)) {
            value = this.getFieldValue(IWStepProcId);
        }
        if (value == null) {
            return -1;
        }
        int result = (Integer)value;
        return result;
    }

    protected Date getReminder() throws VWException {
        Object value = null;
        value = this.getFieldValue(IWReminder, true);
        Date result = null;
        if (value != null && NO_DATE.longValue() != ((Date)value).getTime()) {
            result = (Date)value;
        }
        return result;
    }

    protected String getResponse() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(FResponse, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getSubject() throws VWException {
        Object tmpval = null;
        String value = null;
        tmpval = this.getFieldValue(FSubject, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getWorkflowName() throws VWException {
        Object tmpval = null;
        String value = null;
        tmpval = this.getFieldValue(FWorkflowName, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected boolean getIsTracker() throws VWException {
        Object value = null;
        boolean result = false;
        if (this.hasFieldName(IWIsTracker)) {
            value = this.getFieldValue(IWIsTracker);
            result = (Boolean)value;
        } else {
            value = this.getFieldValue(FIsTracker, true);
            if (value != null && (Integer)value != 0) {
                result = true;
            }
        }
        return result;
    }

    protected String getRosterName() throws VWException {
        String value = null;
        Object tmpval = this.getFieldValue(IWRosterName, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected int getWorkOrderId() throws VWException {
        Object value = null;
        value = this.hasFieldName(VWWorkOrderId) ? this.getFieldValue(VWWorkOrderId) : this.getFieldValue(FWorkOrderId, true);
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    protected String getSourceDoc() throws VWException {
        String value = null;
        Object tmpval = null;
        if (this.hasFieldName(IWSourceDoc)) {
            tmpval = this.getFieldValue(IWSourceDoc);
        }
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected int getWorkSpaceId() throws VWException {
        Object value = null;
        value = this.hasFieldName(VWWorkSpaceId) ? this.getFieldValue(VWWorkSpaceId) : this.getFieldValue(FWorkSpaceId, true);
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    protected int getWorkClassId() throws VWException {
        Object value = null;
        value = this.hasFieldName(VWWorkClassId) ? this.getFieldValue(VWWorkClassId) : this.getFieldValue(FWorkClassId, true);
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    private boolean fieldIsArray(byte[] oldFieldType) throws VWException {
        if (oldFieldType == null) {
            throw new VWException("vw.api.FOInvalidFieldType", "Field type cannot be null.");
        }
        short ch = oldFieldType[0];
        return ch == 91;
    }

    public String getWorkFlowNumber() throws VWException {
        String value = null;
        Object tmpval = null;
        tmpval = this.hasFieldName(IWWorkflowNumber) ? this.getFieldValue(IWWorkflowNumber) : this.getFieldValue(FWorkflowNumber, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    protected String getStepName() throws VWException {
        String value = null;
        Object tmpval = null;
        tmpval = this.hasFieldName(IWStepName) ? this.getFieldValue(IWStepName) : this.getFieldValue(FStepName, true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return value;
    }

    public int getServerLocation() throws VWException {
        Object tmpval = this.getFieldValue(FServerId, true);
        if (tmpval != null && tmpval instanceof Integer) {
            return (Integer)tmpval;
        }
        return 0;
    }

    protected void finalize() throws Throwable {
        this.cleanUp();
    }

    private void cleanUp() {
        if (this.fieldMap != null) {
            Set<String> keys = this.fieldMap.keySet();
            if (keys != null) {
                String[] kArr;
                for (String k : kArr = keys.toArray(new String[0])) {
                    this.fieldMap.remove(k);
                }
            }
            this.fieldMap.clear();
            this.fieldMap = null;
        }
        this.nonHiddenFields = null;
        this.nonSystemFields = null;
    }
}

